/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.filters.ImageFilter;

public class Transparency
implements ImageFilter {
    private final AlphaComposite composite;

    public Transparency(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("The alpha must be between 0.0f and 1.0f, inclusive.");
        }
        this.composite = AlphaComposite.getInstance(3, f2);
    }

    public Transparency(double d) {
        this((float)d);
    }

    public BufferedImage apply(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(this.composite);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public float getAlpha() {
        return this.composite.getAlpha();
    }
}

